package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader

import ru.yandex.direct.core.entity.banner.model.BannerToSendShowTitleAndBodyFlagForBsExport
import java.util.function.Consumer
import org.springframework.stereotype.Component

@Component
class BannerShowTitleAndBodyLoader(
        context: BannerResourcesLoaderContext,
) : BaseBannerResourcesLoader<BannerToSendShowTitleAndBodyFlagForBsExport, Boolean?>(context) {
    override fun getClassToLoadFromDb(): Class<BannerToSendShowTitleAndBodyFlagForBsExport> {
        return BannerToSendShowTitleAndBodyFlagForBsExport::class.java
    }

    override fun getResources(shard: Int, bannersFromDb: List<BannerToSendShowTitleAndBodyFlagForBsExport>): Map<Long, Boolean?> {
        val result: MutableMap<Long, Boolean?> = mutableMapOf()
        bannersFromDb.forEach(Consumer { banner: BannerToSendShowTitleAndBodyFlagForBsExport ->
            if (banner.creativeId == null) {
                result[banner.id] = null
            } else {
                result[banner.id] = banner.showTitleAndBody ?: false
            }
        })
        return result
    }
}
