package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BaseBannerWithResourcesForBsExport;


@Component
public class BannerStopLoader extends BaseBannerResourcesLoader<BaseBannerWithResourcesForBsExport, Boolean> {
    public BannerStopLoader(BannerResourcesLoaderContext context) {
        super(context);
    }

    @Override
    protected Class<BaseBannerWithResourcesForBsExport> getClassToLoadFromDb() {
        return BaseBannerWithResourcesForBsExport.class;
    }

    @Override
    protected Map<Long, Boolean> getResources(int shard, List<BaseBannerWithResourcesForBsExport> bannersFromDb) {
        return StreamEx.of(bannersFromDb).toMap(Banner::getId, this::getBannerStop);
    }

    private Boolean getBannerStop(BaseBannerWithResourcesForBsExport banner) {
        return !banner.getStatusShow() || BannerStatusPostModerate.REJECTED.equals(banner.getStatusPostModerate());
    }
}
