package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithFixedBody;
import ru.yandex.direct.core.entity.banner.model.BannerWithFixedTitle;
import ru.yandex.direct.core.entity.banner.model.BannerWithTitleAndBodyForBsExport;
import ru.yandex.direct.core.entity.banner.model.DynamicBanner;
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.container.TitleAndBody;
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.BannerTextFormatter;

@Component
public class BannerTitleAndBodyLoader extends BaseBannerResourcesLoader<BannerWithTitleAndBodyForBsExport,
        TitleAndBody> {

    private final BannerTextFormatter bannerTextFormatter;

    public BannerTitleAndBodyLoader(BannerResourcesLoaderContext context, BannerTextFormatter bannerTextFormatter) {
        super(context);
        this.bannerTextFormatter = bannerTextFormatter;
    }

    @Override
    protected Class<BannerWithTitleAndBodyForBsExport> getClassToLoadFromDb() {
        return BannerWithTitleAndBodyForBsExport.class;
    }

    @Override
    protected Map<Long, TitleAndBody> getResources(int shard,
                                                   List<BannerWithTitleAndBodyForBsExport> bannersFromDb) {
        Map<Long, TitleAndBody> titleAndBodyMap = new HashMap<>();
        bannersFromDb.stream()
                .filter(this::hasReadyResource)
                .forEach(banner ->
                        titleAndBodyMap.put(banner.getId(), getResource(banner)));
        return titleAndBodyMap;
    }

    private TitleAndBody getResource(BannerWithTitleAndBodyForBsExport banner) {
        var body = Objects.nonNull(banner.getBody()) ? banner.getBody() : "";

        // todo оторвать отправку для Fixed текстов DIRECT-134899 после переотправки всех заголовков и body
        body = banner instanceof BannerWithFixedBody ? "" : bannerTextFormatter.format(body, banner);
        var title = Objects.nonNull(banner.getTitle()) ? banner.getTitle() : "";
        title = banner instanceof BannerWithFixedTitle ? "" : bannerTextFormatter.format(title, banner);
        // для динамических объявлений заголовок всегда одинаковый
        if (!(banner instanceof DynamicBanner)) {
            title = bannerTextFormatter.format(title, banner);
        }
        return TitleAndBody.builder()
                .setBody(body)
                .setTitle(title)
                .build();
    }

    private boolean hasReadyResource(BannerWithTitleAndBodyForBsExport resourceFromDb) {
        return BannerStatusModerate.YES.equals(resourceFromDb.getStatusModerate());
    }
}
