package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithTitleExtensionForBsExport;
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.BannerTextFormatter;

@Component
public class BannerTitleExtensionLoader extends BaseBannerResourcesLoader<BannerWithTitleExtensionForBsExport,
        String> {

    private final BannerTextFormatter bannerTextFormatter;

    public BannerTitleExtensionLoader(BannerResourcesLoaderContext context, BannerTextFormatter bannerTextFormatter) {
        super(context);
        this.bannerTextFormatter = bannerTextFormatter;
    }

    @Override
    protected Class<BannerWithTitleExtensionForBsExport> getClassToLoadFromDb() {
        return BannerWithTitleExtensionForBsExport.class;
    }

    @Override
    protected Map<Long, String> getResources(int shard,
                                             List<BannerWithTitleExtensionForBsExport> bannersFromDb) {
        Map<Long, String> bidTitleExtensionMap = new HashMap<>();
        bannersFromDb.stream()
                .filter(this::hasReadyResource)
                .forEach(banner ->
                        bidTitleExtensionMap.put(banner.getId(), getResource(banner)));
        return bidTitleExtensionMap;
    }

    private String getResource(BannerWithTitleExtensionForBsExport banner) {
        if (Objects.isNull(banner.getTitleExtension())) {
            return "";
        }
        return bannerTextFormatter.format(banner.getTitleExtension(), banner);
    }

    private boolean hasReadyResource(BannerWithTitleExtensionForBsExport resourceFromDb) {
        return BannerStatusModerate.YES.equals(resourceFromDb.getStatusModerate());
    }
}
