package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.MetrikaSnippet
import ru.yandex.direct.core.entity.banner.model.BannerWithZenPublisherIdForBsExport
import ru.yandex.direct.core.entity.banner.repository.BannerRelationsRepository
import ru.yandex.direct.ess.common.utils.TablesEnum
import ru.yandex.direct.ess.logicobjects.bsexport.resources.AdditionalInfo
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.container.ZenSubscribeInfo

@Component
class BannerZenSubscribeLoader(
    bannerResourcesLoaderContext: BannerResourcesLoaderContext,
    private val bannerRelationsRepository: BannerRelationsRepository,
) : BaseBannerResourcesLoader<BannerWithZenPublisherIdForBsExport, ZenSubscribeInfo?>(
    bannerResourcesLoaderContext,
) {
    override fun getClassToLoadFromDb() = BannerWithZenPublisherIdForBsExport::class.java

    override fun getResources(
        shard: Int,
        bannersFromDb: List<BannerWithZenPublisherIdForBsExport>
    ): Map<Long, ZenSubscribeInfo?> {

        val bids = bannersFromDb.asSequence()
            .map { it.id }
            .toSet()

        val metrikaCountersMap = bannerRelationsRepository.getMetrikaCountersByBids(shard, bids)

        val result = HashMap<Long, ZenSubscribeInfo?>()
        bannersFromDb.forEach {
            result[it.id] = ZenSubscribeInfo(
                it.zenPublisherId,
                MetrikaSnippet.newBuilder()
                    .setCounter(metrikaCountersMap[it.id]?.let { counters ->
                        if (counters.size > 0) counters[0] else 0L } ?: 0L)
                    .setGoal("yazen-subscribe")
                    .build()
            )
        }
        return result
    }

    override fun getAdditionalBids(shard: Int, objects: Collection<AdditionalInfo>): List<Long> {
        val cids = objects
            .filter { it.additionalTable == TablesEnum.CAMP_METRIKA_COUNTERS }
            .map { it.additionalId }
            .toSet()

        val bids = bannerRelationsRepository.getBannerIdsByCampaignIds(shard, cids)

        return bannerRelationsRepository.filterBannersWithPublisherId(shard, bids)
    }
}
