package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils

import ru.yandex.direct.core.entity.image.model.Image
import ru.yandex.direct.core.entity.image.model.ImageFormat
import ru.yandex.direct.core.entity.image.model.ImageSizeMeta
import ru.yandex.direct.core.entity.image.model.ImageSmartCenter
import ru.yandex.direct.core.entity.image.service.ImageUtils
import ru.yandex.grut.experimental.banner.BannerResources

typealias TImage = BannerResources.TImagesInfo.TImage
typealias TSmartCenter = BannerResources.TImagesInfo.TImage.TSmartCenter
typealias TMdsMeta = BannerResources.TImagesInfo.TMdsMeta
typealias TBackgroundColors = BannerResources.TImagesInfo.TMdsMeta.TBackgroundColors

object BannerImageConverter {

    fun toImages(image: Image): List<TImage> {
        val sizes = image.mdsMetaWithUserSettings?.sizes.orEmpty()
        return image.formats.map { (formatId, imageFormat) ->
            toImageFormat(image, formatId, imageFormat, sizes[formatId])
        }
    }

    private fun toImageFormat(
        image: Image,
        formatId: String,
        format: ImageFormat,
        sizeMeta: ImageSizeMeta?
    ): TImage {
        // sorted lexicographically by ratio (key of sizeMeta.smartCenters)
        val smartCenters: List<TSmartCenter>? = sizeMeta?.smartCenters?.toSortedMap()?.values
            ?.map { smartCenter -> toSmartCenter(smartCenter) }

        return TImage.newBuilder()
            .setFormat(formatId)
            .setWidth(format.width.toLong())
            .setHeight(format.height.toLong())
            .setUrl(ImageUtils.generateImageUrl(image, formatId))
            .apply { if (smartCenters != null) addAllSmartCenters(smartCenters) }
            .build()
    }

    private fun toSmartCenter(smartCenter: ImageSmartCenter): TSmartCenter {
        return TSmartCenter.newBuilder()
            .setW(smartCenter.width)
            .setH(smartCenter.height)
            .setX(smartCenter.x)
            .setY(smartCenter.y)
            .build()
    }

    fun toMdsMeta(image: Image): TMdsMeta? {
        val mdsMeta = image.mdsMetaWithUserSettings ?: return null

        return TMdsMeta.newBuilder().apply {
            mdsMeta.meta?.colorWizBack?.let { colorWizBack = it }
            mdsMeta.meta?.colorWizButton?.let { colorWizButton = it }
            mdsMeta.meta?.colorWizButtonText?.let { colorWizButtonText = it }
            mdsMeta.meta?.backgroundColors?.let { metaBackgroundColors ->
                backgroundColors = TBackgroundColors.newBuilder().apply {
                    metaBackgroundColors.left?.let { left = it }
                    metaBackgroundColors.right?.let { right = it }
                    metaBackgroundColors.top?.let { top = it }
                    metaBackgroundColors.bottom?.let { bottom = it }
                }.build()
            }
        }.build()
    }

}
