package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields
import ru.yandex.direct.core.entity.bs.common.service.BsBannerIdCalculator
import ru.yandex.direct.ess.logicobjects.bsexport.resources.AdditionalInfo
import ru.yandex.direct.ess.logicobjects.bsexport.resources.BsExportBannerResourcesObject
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.container.BannerResource
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.container.BannerResourcesStat
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.BannerFromDbWithLogicObject
import ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.LoaderResult

fun <T : BannerWithSystemFields, R> getResourceInternal(
    bannerWithObject: BannerFromDbWithLogicObject<T>,
    resource: R?
): BannerResource<R> {
    val bsBannerId =
        if (bannerWithObject.bsBannerId == 0L) BsBannerIdCalculator.calculateBsBannerId(bannerWithObject.bid) else bannerWithObject.bsBannerId
    return BannerResource.Builder<R>()
        .setBid(bannerWithObject.bid)
        .setPid(bannerWithObject.bannerFromDb.adGroupId)
        .setCid(bannerWithObject.bannerFromDb.campaignId)
        .setBsBannerId(bsBannerId)
        .setOrderId(bannerWithObject.orderId)
        .setResource(resource)
        .build()
}

fun getAdditionalInfoList(objects: Collection<BsExportBannerResourcesObject>): List<AdditionalInfo> {
    return objects.mapNotNull { obj: BsExportBannerResourcesObject -> obj.additionalInfo }
}

fun <R> getLoaderResult(
    objects: Collection<Any>,
    resources: List<BannerResource<R>>
): LoaderResult<R> {
    val stat = BannerResourcesStat()
        .setCandidates(objects.size)
        .setSent(resources.size)
    return LoaderResult(resources, stat)
}
