package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.core.entity.banner.model.McBanner;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.TextBanner;

import static ru.yandex.direct.core.entity.banner.service.validation.BannerConstants.TEMPLATE_LABEL_OLD_RE;
import static ru.yandex.direct.core.entity.banner.service.validation.BannerLettersConstants.TEMPLATE_LABEL_RE;

/**
 * Класс, форматирующий текстовые поля для баннера
 */
@Component
public class BannerTextFormatter {

    private static final Set<Class<?>> BANNERS_CAN_BE_TEMPLATE = Set.of(
            TextBanner.class,
            MobileAppBanner.class,
            ImageBanner.class,
            McBanner.class,
            CpmBanner.class,
            CpcVideoBanner.class
    );

    /**
     * Выполняет unescape для символов "&lt;","&gt;","&quot;","&amp;", аналог в перле https://a.yandex-team
     * .ru/arc/trunk/arcadia/direct/perl/protected/TextTools.pm?rev=7406114#L172
     * Заменяет временные метки, аналог в перле https://a.yandex-team
     * .ru/arc/trunk/arcadia/direct/perl/protected/BS/ExportQuery.pm?rev=7406709#L3151
     *
     * @param text   текст для преобразования
     * @param banner объект баннера
     */
    public String format(String text, Banner banner) {
        var result = unescapeHtml(text);
        return replaceTemplateLabel(result, banner);
    }

    String unescapeHtml(String input) {
        return input.replace("&lt;", "<")
                .replace("&gt;", ">")
                .replace("&quot;", "\"")
                .replace("&amp;", "&");
    }

    String replaceTemplateLabel(String input, Banner banner) {
        var result = input;
        if (BANNERS_CAN_BE_TEMPLATE.contains(banner.getClass())) {
            result = input.replaceAll(TEMPLATE_LABEL_RE, "{PHRASE$1}");
            result = result.replaceAll(TEMPLATE_LABEL_OLD_RE, "{PHRASE}");
        }
        return result;
    }
}
