package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href

import org.springframework.stereotype.Service
import ru.yandex.direct.bs.id.generator.BsDomainIdGeneratorClient

@Service
open class BsDomainIdGenerationService(private val client: BsDomainIdGeneratorClient) {
    companion object {
        private const val CHUNK_SIZE = 1000
    }

    open fun generate(domains: Collection<String>): Map<String, Long> {
        val result = mutableMapOf<String, Long>()
        domains
            .filterNot { "" == it }
            .chunked(CHUNK_SIZE)
            .forEach { result.putAll(client.generate(it)) }
        return result
    }
}
