package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.mobilecontent;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import ru.yandex.direct.utils.model.UrlParts;

import static org.springframework.core.Ordered.HIGHEST_PRECEDENCE;

@Component
@Order(HIGHEST_PRECEDENCE) // use any value higher than LOWEST_PRECEDENCE so the default handler will be processed last
public class AdjustTrackerHrefHandler extends BaseTrackerHrefHandler {
    static final String INSTALL_CALLBACK_PARAM = "install_callback";
    static final String CONVERSION_CALLBACK_PARAM = "conversion_callback";
    static final String CALLBACK_DOMAIN = "postback.yandexadexchange.net";

    @Override
    List<String> domainPatterns() {
        return List.of(
                "(^|\\.)adjust\\.(com|io)",
                "(^|\\.)adj\\.st$"
        );
    }

    @Override
    void initParameters() {
        addPermanentIosIfaParameter("idfa");
        addPermanentGoogleAidParameter("gps_adid");
        addPermanentOaidParameter("oaid");
        addPermanentTrackIdParameter("ya_click_id");
    }

    @Override
    UrlParts.Builder postProcessBuilder(UrlParts.Builder builder) {
        var parameters = builder.build().getParameters();
        if (parameters == null) {
            return builder;
        }
        parameters = parameters.stream()
                .filter(p -> (p.getKey().compareToIgnoreCase(INSTALL_CALLBACK_PARAM) != 0 && p.getKey().compareToIgnoreCase(CONVERSION_CALLBACK_PARAM) != 0) || !p.getValue().contains(CALLBACK_DOMAIN))
                .collect(Collectors.toList());
        return builder.withParameters(parameters);
    }
}
