package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.mobilecontent;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.mobilecontent.model.OsType;

import static org.springframework.core.Ordered.HIGHEST_PRECEDENCE;

@Component
@Order(HIGHEST_PRECEDENCE) // use any value higher than LOWEST_PRECEDENCE so the default handler will be processed last
public class AppsFlyerTrackerHrefHandler extends BaseTrackerHrefHandler {
    private static final String CAMPAIGN_NAME_PARAM = "c";

    @Override
    List<String> domainPatterns() {
        return List.of("^(app|impression)\\.appsflyer\\.com$");
    }

    @Override
    void initParameters() {
        addPermanentIosIfaParameter("idfa");
        addPermanentGoogleAidParameter("advertising_id");
        addPermanentTrackIdParameter("clickid");
        addPermanentOaidParameter("oaid");
        addPermanentParameter("af_c_id", "{campaign_id}");
        addPermanentParameter("pid", "yandexdirect_int");
    }

    @Override
    Map<String, String> getDependentParameters(OsType osType, List<Pair<String, String>> hrefParameters) {
        if (hrefParameters == null || hrefParameters.stream().allMatch(
                p -> p.getKey().compareToIgnoreCase(CAMPAIGN_NAME_PARAM) != 0 || p.getValue().equals("")
        )) {
            return Map.of(CAMPAIGN_NAME_PARAM, "{campaign_name}");
        }
        return Map.of();
    }
}
