package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.mobilecontent;

import java.util.List;

import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import static org.springframework.core.Ordered.HIGHEST_PRECEDENCE;

@Component
@Order(HIGHEST_PRECEDENCE) // use any value higher than LOWEST_PRECEDENCE so the default handler will be processed last
public class BranchTrackerHrefHandler extends BaseTrackerHrefHandler {
    @Override
    List<String> domainPatterns() {
        return List.of("(^|\\.)app\\.link$");
    }

    @Override
    void initParameters() {
        addPermanentIosIfaParameter("%24idfa");
        addPermanentGoogleAidParameter("%24aaid");
        addPermanentTrackIdParameter("~click_id");
        addPermanentParameter("%243p", "a_yandex_direct");
    }
}
