package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.mobilecontent;

import java.util.List;

import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import static org.springframework.core.Ordered.HIGHEST_PRECEDENCE;

@Component
@Order(HIGHEST_PRECEDENCE) // use any value higher than LOWEST_PRECEDENCE so the default handler will be processed last
public class FlurryTrackerHrefHandler extends BaseTrackerHrefHandler {
    @Override
    List<String> domainPatterns() {
        return List.of(
                "(^|\\.)ad\\.apps\\.fm$",
                "(^|\\.)flurry\\.com$"
        );
    }

    @Override
    void initParameters() {
        addPermanentIosIfaParameter("ios_idfa");
        addPermanentGoogleAidParameter("adid");
        addPermanentTrackIdParameter("click_id");
    }


}
