package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.mobilecontent;

import java.util.List;

import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.mobilecontent.model.OsType;

import static org.springframework.core.Ordered.HIGHEST_PRECEDENCE;

@Component
@Order(HIGHEST_PRECEDENCE) // use any value higher than LOWEST_PRECEDENCE so the default handler will be processed last
public class KochavaTrackerHrefHandler extends BaseTrackerHrefHandler {
    @Override
    List<String> domainPatterns() {
        return List.of(
                "(^|\\.)kochava.com$"
        );
    }

    @Override
    void initParameters() {
        addPermanentIosIfaParameter("ios_idfa");
        addPermanentGoogleAidParameter("adid");
        // Для kocahva нужен то ли google_aid, то ли android_id -проверяем оба для надежности
        addPermanentOsSpecifiedParameter(OsType.ANDROID, "android_id", "{android_id}");
    }


}
