package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.mobilecontent;

import java.util.List;

import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import static org.springframework.core.Ordered.HIGHEST_PRECEDENCE;

@Component
@Order(HIGHEST_PRECEDENCE) // use any value higher than LOWEST_PRECEDENCE so the default handler will be processed last
public class MatTuneTrackerHrefHandler extends BaseTrackerHrefHandler {
    @Override
    List<String> domainPatterns() {
        return List.of("(^|\\.)hastrk[0-9]{1,2}\\.com$",
                "(^|\\.)api-[0-9]{1,2}\\.com$",
                "(^|\\.)measurementapi\\.com$",
                "(^|\\.)tlnk\\.io$");
    }

    @Override
    void initParameters() {
        addPermanentIosIfaParameter("ios_ifa");
        addPermanentGoogleAidParameter("google_aid");
        addPermanentTrackIdParameter("publisher_ref_id");
    }


}
