package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.mobilecontent;

import java.util.List;

import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.mobilecontent.model.OsType;

import static org.springframework.core.Ordered.HIGHEST_PRECEDENCE;

@Component
@Order(HIGHEST_PRECEDENCE) // use any value higher than LOWEST_PRECEDENCE so the default handler will be processed last
public class SingularTrackerHrefHandler extends BaseTrackerHrefHandler {
    @Override
    List<String> domainPatterns() {
        return List.of("(^|\\.)sng\\.link$");
    }

    @Override
    void initParameters() {
        addPermanentIosIfaParameter("idfa");
        addPermanentGoogleAidParameter("aifa");
        addPermanentOsSpecifiedParameter(OsType.ANDROID, "andi", "{android_id}");
        addPermanentOaidParameter("oaid");
        addPermanentTrackIdParameter("cl");
    }
}
