package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.mobilecontent;

import java.util.List;
import java.util.Objects;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.mobilecontent.model.OsType;


/**
 * Сервис для добавления параметров к url баннера в зависимости от трекинговой системы для приложения и типа ОС
 */
@Component
public class TrackerHrefHandleService {
    private final List<BaseTrackerHrefHandler> trackerHrefHandlers;

    public TrackerHrefHandleService(List<BaseTrackerHrefHandler> trackerHrefHandlers) {
        this.trackerHrefHandlers = trackerHrefHandlers;
    }

    /**
     * Определяет трекинговую систему для ссылки, добавляет параметры к ссылке согласно трекинговой системе
     * Если трекинговую систему определить не удается, то использует дефолтный обработчик
     * Если не удалось обработать ссылку даже дефолтным обработчиком, то возвращает исходную ссылку
     */
    public String handleHref(String href, OsType osType) {
        return trackerHrefHandlers.stream()
                .map(handler -> handler.handle(href, osType))
                .filter(Objects::nonNull)
                .findFirst()
                .orElse(href);
    }
}
