package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.parameterizer;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

import static java.nio.charset.StandardCharsets.UTF_8;

/**
 * Заменяет в ссылке параметры на подстановки или макросы БК
 * Если параметр неизвестен, подстановки не происходит
 * Аналог perl https://a.yandex-team.ru/arc/trunk/arcadia/direct/perl/protected/BS/ExportQuery.pm?rev=7482496#L4992
 */
@Component
public class BsHrefParametrizingService {
    private final Pattern pattern;
    private final ParamConverter paramConverter;

    public BsHrefParametrizingService(ParamConverter paramConverter) {
        this.paramConverter = paramConverter;
        this.pattern = Pattern.compile("(\\{[^{}]+})");
    }

    public String parameterize(String href, ReplacingParams params) {
        Matcher matcher = pattern.matcher(href);
        return matcher.replaceAll(f -> Matcher.quoteReplacement(getReplacement(f, params)));
    }

    private String getReplacement(MatchResult matchResult, ReplacingParams params) {
        var group = matchResult.group();
        String token = group.substring(1, group.length() - 1).toLowerCase();
        var replacingResult = paramConverter.convert(token, params);

        if (replacingResult.isNotFound()) {
            return group;
        }
        if (replacingResult.isMacro()) {
            return "{" + replacingResult.getResult() + "}";
        }
        return UriUtils.encode(replacingResult.getResult(), UTF_8);

    }
}
