package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.parameterizer;

class ConversionResult {
    private final String result;
    private final boolean isMacro;
    private final boolean notFound;

    public ConversionResult(String result, boolean isMacro, boolean notFound) {
        this.result = result;
        this.isMacro = isMacro;
        this.notFound = notFound;
    }

    /**
     * На место параметра нужно подставить конкретное значение result
     */
    public static ConversionResult substitution(String result) {
        return new ConversionResult(result, false, false);
    }

    /**
     * На место параметра нужно подставить макрос для БК
     */
    public static ConversionResult macro(String result) {
        return new ConversionResult(result, true, false);
    }

    /**
     * Для параметра не нашлось подстановки
     */
    public static ConversionResult notFound() {
        return new ConversionResult(null, false, true);
    }

    public String getResult() {
        return result;
    }

    public boolean isMacro() {
        return isMacro;
    }

    public boolean isNotFound() {
        return notFound;
    }
}
