package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.parameterizer;

import java.util.Map;

import one.util.streamex.EntryStream;

import ru.yandex.direct.hrefs.parameterizer.HrefParameter;

import static java.util.Map.entry;
import static ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.parameterizer.ConversionResult.macro;

/**
 * Конвертирует токены в макросы БК
 */
public class MacroConverter {

    private static final Map<HrefParameter, ConversionResult> BS_MACRO_MAP = Map.ofEntries(
            entry(HrefParameter.ADD_PHRASES, macro("BM")),
            entry(HrefParameter.ADD_PHRASES_TEXT, macro("PHRASE_BM")),
            entry(HrefParameter.CREATIVE_ID, macro("CREATIVE_ID")),
            entry(HrefParameter.POSITION_TYPE, macro("PTYPE")),
            entry(HrefParameter.ADTARGET_ID, macro("PHRASE_EXPORT_ID")),
            entry(HrefParameter.GBID, macro("GBID")),
            entry(HrefParameter.LOGID, macro("LOGID")),
            entry(HrefParameter.TRACKID, macro("TRACKID")),
            entry(HrefParameter.MATCH_TYPE, macro("MATCH_TYPE")),
            entry(HrefParameter.MATCHED_KEYWORD, macro("PHRASE_RKW")),
            entry(HrefParameter.OFFER_ID, macro("OFFER_ID")),
            entry(HrefParameter.IDFA_LC_MD5_HEX, macro("IDFA_UC_MD5_HEX")),
            entry(HrefParameter.IDFA_LC_SH1_HEX, macro("IDFA_UC_SH1_HEX")),
            entry(HrefParameter.IOS_IFA, macro("IDFA_UC")),
            entry(HrefParameter.INTEREST_ID, macro("PARAM125")),
            entry(HrefParameter.GOOGLE_AID_LC_SH1, macro("GOOGLE_AID_LC_SH1_HEX")),
            entry(HrefParameter.GOOGLE_AID, macro("GOOGLE_AID_LC")),
            entry(HrefParameter.COEF_GOAL_CONTEXT_ID, macro("COEF_GOAL_CONTEXT_ID")),
            entry(HrefParameter.ANDROID_ID_LC_SH1, macro("ANDROID_ID_LC_SH1_HEX")),
            entry(HrefParameter.ANDROID_ID, macro("ANDROID_ID_LC")),
            entry(HrefParameter.ADTARGET_NAME, macro("PARAM126")),
            entry(HrefParameter.REGION_ID, macro("REG_BS")),
            entry(HrefParameter.REGION_NAME, macro("REGN_BS")),
            entry(HrefParameter.DEVICE_TYPE, macro("DEVICE_TYPE")),
            entry(HrefParameter.KEYWORD, macro("PHRASE")),
            entry(HrefParameter.PARAM1, macro("PARAM1")),
            entry(HrefParameter.PARAM2, macro("PARAM2")),
            entry(HrefParameter.PHRASE_ID, macro("PHRASE_EXPORT_ID")),
            entry(HrefParameter.RETARGETING_ID, macro("PARAM126")),
            entry(HrefParameter.POSITION, macro("POS")),
            entry(HrefParameter.SOURCE, macro("SRC")),
            entry(HrefParameter.SOURCE_TYPE, macro("STYPE")),
            entry(HrefParameter.OAID, macro("OAID")),
            entry(HrefParameter.OAID_LC, macro("OAID_LC")),
            entry(HrefParameter.OAID_LC_SH1_HEX, macro("OAID_LC_SH1_HEX")),
            entry(HrefParameter.OAID_LC_MD5_HEX, macro("OAID_LC_MD5_HEX")),
            entry(HrefParameter.CLIENTIP, macro("CLIENTIP")),
            entry(HrefParameter.USER_AGENT, macro("USER_AGENT")),
            entry(HrefParameter.DEVICE_LANG, macro("DEVICE_LANG")),
            entry(HrefParameter.YCLID, macro("YCLID"))
    );
    private Map<String, ConversionResult> replacingFunctionMap;

    public MacroConverter() {
        initReplacingFunctionMap();
    }

    public ConversionResult replace(String token) {
        if (replacingFunctionMap.containsKey(token)) {
            return replacingFunctionMap.get(token);
        }
        return null;
    }

    private void initReplacingFunctionMap() {
        replacingFunctionMap = EntryStream.of(BS_MACRO_MAP)
                .flatMapKeys(hrefParam -> hrefParam.getKeys().stream())
                .toMap();
    }
}
