package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.parameterizer;

import java.util.Objects;

import org.springframework.stereotype.Component;

import static ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.parameterizer.ConversionResult.notFound;


/**
 * Конвертирует параметры ссылки. Если для параметра делается подстановка из параметров - возвращает значение
 * подстановки. Иначе возвращает макрос БК
 */
@Component
class ParamConverter {

    private final SubstitutionConverter substitutionConverter = new SubstitutionConverter();
    private final MacroConverter macroConverter = new MacroConverter();

    public ConversionResult convert(String token, ReplacingParams replacingParams) {

        var result = substitutionConverter.replace(token, replacingParams);
        if (Objects.nonNull(result)) {
            return result;
        }
        result = macroConverter.replace(token);
        if (Objects.nonNull(result)) {
            return result;
        }
        return notFound();
    }
}
