package ru.yandex.direct.logicprocessor.processors.bsexport.resources.loader.utils.href.parameterizer;

import java.util.Objects;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.hrefs.parameterizer.HrefParameter;

import static com.google.common.base.Preconditions.checkArgument;

public class ReplacingParams {
    private final Long bid;
    private final Long pid;
    private final Long cid;
    private final CampaignType campaignType;
    private final String campaignName;
    private final String campaignNameLat;
    private final CurrencyCode campaignCurrency;
    private final DbStrategy campaignStrategy;

    private ReplacingParams(Long bid, Long pid, Long cid, CampaignType campaignType,
                            String campaignName, String campaignNameLat,
                            CurrencyCode campaignCurrency, DbStrategy campaignStrategy) {
        this.bid = bid;
        this.pid = pid;
        this.cid = cid;
        this.campaignType = campaignType;
        this.campaignName = campaignName;
        this.campaignNameLat = campaignNameLat;
        this.campaignCurrency = campaignCurrency;
        this.campaignStrategy = campaignStrategy;
    }

    public static Builder builder() {
        return new Builder();
    }

    /**
     * Может быть null при условии, что тип группы - dynamic или performance
     * В этом случае {@link SubstitutionConverter} будет
     * заменять {@link HrefParameter#AD_ID} на макрос, а не на bid
     */
    @Nullable
    public Long getBid() {
        return bid;
    }

    public Long getPid() {
        return pid;
    }

    public Long getCid() {
        return cid;
    }

    public CampaignType getCampaignType() {
        return campaignType;
    }

    public String getCampaignName() {
        return campaignName;
    }

    public String getCampaignNameLat() {
        return campaignNameLat;
    }

    public CurrencyCode getCampaignCurrency() {
        return campaignCurrency;
    }

    public DbStrategy getCampaignStrategy() {
        return campaignStrategy;
    }

    @Override
    public String toString() {
        return "ReplacingParams{" +
                "bid=" + bid +
                ", pid=" + pid +
                ", cid=" + cid +
                ", campaignType=" + campaignType +
                ", campaignName='" + campaignName + '\'' +
                ", campaignNameLat='" + campaignNameLat + '\'' +
                ", campaignCurrency='" + campaignCurrency + '\'' +
                ", campaignStrategy='" + campaignStrategy + '\'' +
                '}';
    }

    public static final class Builder {
        private Long bid;
        private Long pid;
        private Long cid;
        private CampaignType campaignType;
        private String campaignName;
        private String campaignNameLat;
        private CurrencyCode campaignCurrency;
        private DbStrategy campaignStrategy;

        private Builder() {
        }

        public Builder withBid(Long bid) {
            this.bid = bid;
            return this;
        }

        public Builder withPid(Long pid) {
            this.pid = pid;
            return this;
        }

        public Builder withCid(Long cid) {
            this.cid = cid;
            return this;
        }

        public Builder withCampaignType(CampaignType campaignType) {
            this.campaignType = campaignType;
            return this;
        }

        public Builder withCampaignName(String campaignName) {
            this.campaignName = campaignName;
            return this;
        }

        public Builder withCampaignNameLat(String campaignNameLat) {
            this.campaignNameLat = campaignNameLat;
            return this;
        }

        public Builder withCampaignCurrency(CurrencyCode campaignCurrency) {
            this.campaignCurrency = campaignCurrency;
            return this;
        }

        public Builder withCampaignStrategy(DbStrategy campaignStrategy) {
            this.campaignStrategy = campaignStrategy;
            return this;
        }

        @Override
        public String toString() {
            return "Builder{" +
                    "bid=" + bid +
                    ", pid=" + pid +
                    ", cid=" + cid +
                    ", campaignType=" + campaignType +
                    ", campaignName='" + campaignName + '\'' +
                    ", campaignNameLat='" + campaignNameLat + '\'' +
                    ", campaignCurrency='" + campaignCurrency + '\'' +
                    ", campaignStrategy='" + campaignStrategy + '\'' +
                    '}';
        }

        public ReplacingParams build() {
            checkArgument(Objects.nonNull(pid), "Pid parameter can't be null, " + this);
            checkArgument(Objects.nonNull(cid), "Cid parameter can't be null, " + this);
            checkArgument(Objects.nonNull(campaignType), "CampaignType parameter can't be null, " + this);
            checkArgument(Objects.nonNull(campaignName), "CampaignName parameter can't be null, " + this);
            checkArgument(Objects.nonNull(campaignNameLat), "CampaignNameLat parameter can't be null, " + this);
            return new ReplacingParams(bid, pid, cid, campaignType, campaignName, campaignNameLat, campaignCurrency, campaignStrategy);
        }
    }
}
