package ru.yandex.direct.logicprocessor.processors.bsexport.resync

import org.springframework.beans.factory.annotation.Value
import org.springframework.stereotype.Component
import ru.yandex.direct.scheduler.support.ParametersSource


abstract class TableToQueueParamSource(
    val chunksCnt: Int
) : ParametersSource<Int> {
    private val parameters: List<Int> = (0 until chunksCnt).toList()


    override fun convertParamToString(paramValue: Int): String {
        return paramValue.toString()
    }

    override fun convertStringToParam(string: String): Int {
        return string.toInt()
    }

    override fun getAllParamValues(): List<Int> {
        return parameters
    }
}

@Component
class BannerResourcesTableToQueueParamSource(@Value("\${bs_export.banner_resources.resync.chunks_cnt}") chunksCnt: Int)
    : TableToQueueParamSource(chunksCnt)

@Component
class AdGroupsTableToQueueParamSource(@Value("\${bs_export.ad_groups.resync.chunks_cnt}") chunksCnt: Int)
    : TableToQueueParamSource(chunksCnt)

@Component
class AdGroupsShowConditionTableToQueueParamSource(@Value("\${bs_export.ad_groups_show_condition.resync.chunks_cnt}") chunksCnt: Int)
    : TableToQueueParamSource(chunksCnt)
