package ru.yandex.direct.logicprocessor.processors.bsexport.resync.adgroups

import ru.yandex.adv.direct.adgroup.AdGroupShowCondition
import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.bstransport.yt.repository.adgroup.AdGroupsPosition
import ru.yandex.direct.bstransport.yt.service.adgroups.AdGroupsShowConditionTableToQueueResyncService
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames.*
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.CheckTag
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.logicprocessor.processors.bsexport.resync.AdGroupsShowConditionTableToQueueParamSource
import ru.yandex.direct.logicprocessor.processors.bsexport.resync.BaseTableToQueueResyncJob
import ru.yandex.direct.logicprocessor.processors.bsexport.resync.State
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.scheduler.HourglassDaemon
import ru.yandex.direct.scheduler.support.ParameterizedBy
import ru.yandex.direct.utils.JsonUtils
import java.time.Instant


/**
 * Джоба для переотправки условий показа из сортированной таблицы в очередь Casesar
 * Нужно для того, чтобы если на стороне Caesar что то случилось с условиямии показа,
 * мы бы его гарантированно переотправили в течение 2х недель
 * Кроме того, она позволяет проверять корректность работы механизма переотправки.
 */
@JugglerCheck(ttl = JugglerCheck.Duration(minutes = 20),
    needCheck = ProductionOnly::class,
    notifications = [OnChangeNotification(
        recipient = [NotificationRecipient.CHAT_DIRECT_BS_TRANSPORT_YT_MONITORING],
        method = [NotificationMethod.TELEGRAM],
        status = [JugglerStatus.OK, JugglerStatus.CRIT]
    )],
    tags = [CheckTag.DIRECT_PRIORITY_1, CheckTag.DIRECT_BS_EXPORT]
)
@Hourglass(periodInSeconds = 1)
@HourglassDaemon
@ParameterizedBy(parametersSource = AdGroupsShowConditionTableToQueueParamSource::class)
class AdGroupsShowConditionTableToQueueResyncJob(
    tableToQueueResyncService: AdGroupsShowConditionTableToQueueResyncService,
    private val ppcPropertiesSupport: PpcPropertiesSupport,
    paramSource: AdGroupsShowConditionTableToQueueParamSource)
    : BaseTableToQueueResyncJob<AdGroupShowCondition, AdGroupsPosition>(tableToQueueResyncService, paramSource) {

    override val metricsPrefix = "ad_groups_show_condition"
    override val chunkSizeProperty = ppcPropertiesSupport.get(AD_GROUPS_SHOW_CONDITION_TABLE_TO_QUEUE_JOB_CHUNK)
    override val relaxTimeProperty = ppcPropertiesSupport.get(AD_GROUPS_SHOW_CONDITION_TABLE_TO_QUEUE_JOB_RELAX_TIME)

    private val adGroupStateType = JsonUtils.getTypeFactory().constructParametricType(State::class.java, AdGroupsPosition::class.java)
    override fun getTableToQueueStateProp(param: String) =
        ppcPropertiesSupport.get(adGroupsShowConditionTableToQueueResyncState(param))


    override fun getState(jsonState: String?): State<AdGroupsPosition> {
        return if (jsonState == null) defaultState()
        else JsonUtils.fromJson(jsonState, adGroupStateType)
    }

    private fun defaultState(): State<AdGroupsPosition> {
        return State(Instant.now().epochSecond, 0L, AdGroupsPosition(ytHashBorders.first, 0L))
    }
}
