package ru.yandex.direct.logicprocessor.processors.bsexport.resync.banners

import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.bstransport.yt.repository.resources.ResourcesPosition
import ru.yandex.direct.bstransport.yt.service.resources.BannerResourcesTableToQueueResyncService
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcProperty
import ru.yandex.direct.common.db.PpcPropertyNames.*
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.CheckTag
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.logicprocessor.processors.bsexport.resync.BannerResourcesTableToQueueParamSource
import ru.yandex.direct.logicprocessor.processors.bsexport.resync.BaseTableToQueueResyncJob
import ru.yandex.direct.logicprocessor.processors.bsexport.resync.State
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.scheduler.HourglassDaemon
import ru.yandex.direct.scheduler.support.ParameterizedBy
import ru.yandex.direct.utils.JsonUtils
import java.time.Instant


/**
 * Джоба для переотправки ресурсов баннера из сортированной таблицы в очередь Casesar
 * Нужно для того, чтобы если на стороне Caesar что то случилось с баннером,
 * мы бы его гарантированно переотправили в течение 2х недель
 * Кроме того, она позволяет проверять корректность работы механизма переотправки.
 *
 */
@JugglerCheck(ttl = JugglerCheck.Duration(minutes = 5),
    needCheck = ProductionOnly::class,
    notifications = [OnChangeNotification(
        recipient = [NotificationRecipient.CHAT_DIRECT_BS_TRANSPORT_YT_MONITORING],
        method = [NotificationMethod.TELEGRAM],
        status = [JugglerStatus.OK, JugglerStatus.CRIT]
    )],
    tags = [CheckTag.DIRECT_PRIORITY_1, CheckTag.DIRECT_BS_EXPORT]
)
@Hourglass(periodInSeconds = 1)
@HourglassDaemon
@ParameterizedBy(parametersSource = BannerResourcesTableToQueueParamSource::class)
class BannerResourcesTableToQueueResyncJob(
    private val tableToQueueResyncService: BannerResourcesTableToQueueResyncService,
    private val ppcPropertiesSupport: PpcPropertiesSupport,
    private val paramSource: BannerResourcesTableToQueueParamSource)
    : BaseTableToQueueResyncJob<BannerResources, ResourcesPosition>(tableToQueueResyncService, paramSource) {


    override val metricsPrefix = "banner_resources"
    override val chunkSizeProperty = ppcPropertiesSupport.get(BANNER_RESOURCES_SORTED_TABLE_TO_QUEUE_JOB_CHUNK)
    override val relaxTimeProperty = ppcPropertiesSupport.get(BANNER_RESOURCES_SORTED_TABLE_TO_QUEUE_JOB_RELAX_TIME)
    private lateinit var bannerResourcesTableToQueueStateProp: PpcProperty<String>

    override fun getTableToQueueStateProp(param: String) = ppcPropertiesSupport.get(bannerResourcesTableToQueueResyncState(param))

    private val adGroupStateType = JsonUtils.getTypeFactory().constructParametricType(State::class.java, ResourcesPosition::class.java)
    override fun getState(jsonState: String?): State<ResourcesPosition> {
        return if (jsonState == null) defaultState()
        else JsonUtils.fromJson(jsonState, adGroupStateType)
    }


    private fun defaultState(): State<ResourcesPosition> {
        return State(Instant.now().epochSecond, 0L, ResourcesPosition(ytHashBorders.first, 0L, 0L))
    }


}
