package ru.yandex.direct.logicprocessor.processors.bsexport.strategy;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.bsexport.BsExportStrategyConfig;
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.BsExportStrategyObject;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_BS_EXPORT;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_2;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_2, DIRECT_BS_EXPORT},
        notifications = @OnChangeNotification(
                recipient = NotificationRecipient.LOGIN_SSDMITRIEV,
                status = {JugglerStatus.OK, JugglerStatus.CRIT},
                method = NotificationMethod.TELEGRAM))
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class)
@EssLogicProcessor(BsExportStrategyConfig.class)
public class BsExportStrategyProcessor extends BaseLogicProcessor<BsExportStrategyObject> {

    private final BsExportStrategyService bsExportStrategyService;

    @Autowired
    public BsExportStrategyProcessor(EssLogicProcessorContext essLogicProcessorContext,
                                     BsExportStrategyService bsExportStrategyService) {
        super(essLogicProcessorContext);
        this.bsExportStrategyService = bsExportStrategyService;
    }

    @Override
    public void process(List<BsExportStrategyObject> logicObjects) {
        bsExportStrategyService.processStrategies(getShard(), logicObjects);
    }
}
