package ru.yandex.direct.logicprocessor.processors.bsexport.strategy.handler

import javax.annotation.ParametersAreNonnullByDefault
import ru.yandex.direct.core.entity.client.model.Client
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.BsExportStrategyObject
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.StrategyResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.strategy.container.StrategyHandlerContainer
import ru.yandex.direct.logicprocessor.processors.bsexport.strategy.container.StrategyWithBuilder

@ParametersAreNonnullByDefault
interface IStrategyResourceHandler {
    val resourceType: StrategyResourceType

    /**
     * Возвращает ID стратегий, которые будут обновлены этим хэндлером.
     */
    fun getStrategyIdsToLoad(shard: Int, objects: Collection<BsExportStrategyObject>): Collection<Long> =
        objects.map { it.strategyId }

    /**
     * Дополняет билдеры стратегий
     */
    fun handle(container: StrategyHandlerContainer, strategyById: Map<Long, StrategyWithBuilder<BaseStrategy>>)

    fun <S : BaseStrategy> hasClientId(
        clientById: Map<Long, Client>,
        strategyWithBuilder: StrategyWithBuilder<S>
    ) = clientById.containsKey(getClientId(strategyWithBuilder))

    fun <S : BaseStrategy> getClient(
        clientById: Map<Long, Client>,
        strategyWithBuilder: StrategyWithBuilder<S>
    ) = clientById.getValue(getClientId(strategyWithBuilder))

    private fun <S : BaseStrategy> getClientId(strategyWithBuilder: StrategyWithBuilder<S>): Long =
        (strategyWithBuilder.strategy as? CommonStrategy)!!.clientId
}
