package ru.yandex.direct.logicprocessor.processors.bsexport.strategy.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.strategy.Strategy
import ru.yandex.direct.core.entity.strategy.model.StrategyDayBudgetShowMode
import ru.yandex.direct.core.entity.strategy.model.StrategyWithDayBudget
import ru.yandex.direct.currency.CurrencyCode
import ru.yandex.direct.currency.Money
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.StrategyResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.strategy.container.StrategyHandlerContainer
import ru.yandex.direct.logicprocessor.processors.bsexport.strategy.container.StrategyWithBuilder
import ru.yandex.direct.logicprocessor.processors.bsexport.strategy.handler.StrategyDayBudgetHandler.StrategyDayBudgetShowModeConverter.toExportDayBudgetShowMode

@Component
class StrategyDayBudgetHandler : TypedStrategyResourceHandler<StrategyWithDayBudget>() {
    override val resourceType = StrategyResourceType.DAY_BUDGET
    override val strategiesToLoad = StrategyWithDayBudget::class.java

    override fun fillExportObjects(
        container: StrategyHandlerContainer, strategyById: Map<Long, StrategyWithBuilder<StrategyWithDayBudget>>
    ) {
        container.clientById
        strategyById.values.forEach {
            fillDayBudgetValues(
                getClient(container.clientById, it).workCurrency,
                it.strategy,
                it.builder
            )
        }
    }

    private fun fillDayBudgetValues(
        currencyCode: CurrencyCode, strategy: StrategyWithDayBudget, builder: Strategy.Builder
    ) {
        val dayBudgetInMicros = Money.valueOf(strategy.dayBudget, currencyCode).micros()

        builder.dayBudget = dayBudgetInMicros
        builder.dayBudgetShowMode = toExportDayBudgetShowMode(strategy.dayBudgetShowMode).number
    }

    object StrategyDayBudgetShowModeConverter {
        private val coreToExportDayBudgetShowMode: Map<StrategyDayBudgetShowMode, ru.yandex.adv.direct.strategy.DayBudgetShowMode> =
            mapOf(
                StrategyDayBudgetShowMode.STRETCHED to ru.yandex.adv.direct.strategy.DayBudgetShowMode.STRETCHED,
                StrategyDayBudgetShowMode.DEFAULT_ to ru.yandex.adv.direct.strategy.DayBudgetShowMode.DAY_BUDGET_SHOW_MODE_DEFAULT,
            )

        fun toExportDayBudgetShowMode(source: StrategyDayBudgetShowMode): ru.yandex.adv.direct.strategy.DayBudgetShowMode {
            return coreToExportDayBudgetShowMode[source]
                ?: throw IllegalArgumentException("Unknown strategy platform: $source")
        }
    }
}
