package ru.yandex.direct.logicprocessor.processors.bsexport.strategy.handler

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.model.StrategyWithInventoriData
import ru.yandex.direct.core.entity.strategy.type.withinventoridata.StrategyInventoriDataRepository
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.StrategyResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.strategy.container.StrategyHandlerContainer
import ru.yandex.direct.logicprocessor.processors.bsexport.strategy.container.StrategyWithBuilder

@Component
class StrategyInventoriDataHandler(
    private val strategyInventoriDataRepository : StrategyInventoriDataRepository
) : TypedStrategyResourceHandler<StrategyWithInventoriData>() {
    override val strategiesToLoad = StrategyWithInventoriData::class.java

    override val resourceType = StrategyResourceType.INVENTORI_DATA;

    override fun fillExportObjects(
        container: StrategyHandlerContainer, strategyById: Map<Long, StrategyWithBuilder<StrategyWithInventoriData>>
    ) {

        if (strategyById.isEmpty()) {
            return
        }
        val generalProbabilitiesByStrategyId = strategyInventoriDataRepository.getStrategyInventoriData(
            container.shard, strategyById.keys)

        strategyById.values.forEach {
            it.builder.setGeneralInitialAuctionProbability(generalProbabilitiesByStrategyId.get(it.strategy.id) ?: 0L)
        }
    }
}
