package ru.yandex.direct.logicprocessor.processors.bsexport.strategy.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.strategy.Strategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMeaningfulGoals
import ru.yandex.direct.currency.CurrencyCode
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.StrategyResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.strategy.container.StrategyHandlerContainer
import ru.yandex.direct.logicprocessor.processors.bsexport.strategy.container.StrategyWithBuilder
import ru.yandex.direct.logicprocessor.processors.bsexport.utils.MeaningfulGoalConverter

@Component
class StrategyMeaningfulGoalsHandler :
    TypedStrategyResourceHandler<StrategyWithMeaningfulGoals>() {

    override val strategiesToLoad = StrategyWithMeaningfulGoals::class.java

    override val resourceType = StrategyResourceType.MEANINGFUL_GOALS

    override fun fillExportObjects(
        container: StrategyHandlerContainer,
        strategyById: Map<Long, StrategyWithBuilder<StrategyWithMeaningfulGoals>>
    ) {
        //любая стратегия является наследником CommonStrategy
        strategyById.values
            .forEach { fillMeaningfulGoals(getClient(container.clientById, it).workCurrency, it.strategy, it.builder) }
    }

    private fun fillMeaningfulGoals(
        currencyCode: CurrencyCode,
        strategy: StrategyWithMeaningfulGoals,
        builder: Strategy.Builder
    ) {
        val convertedMeaningfulGoals = strategy.meaningfulGoals
            ?.map { MeaningfulGoalConverter.meaningfulGoalToProto(currencyCode, it) }
            ?.toList() ?: listOf()
        builder.meaningfulGoalsBuilder
            .addAllMeaningfulGoal(convertedMeaningfulGoals)
    }

}
