package ru.yandex.direct.logicprocessor.processors.bsexport.strategy.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.strategy.Strategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMetrikaCounters
import ru.yandex.direct.ess.logicobjects.bsexport.strategy.StrategyResourceType

@Component
class StrategyMetrikaCounterIdsHandler : TypedStrategyResourceHandler<StrategyWithMetrikaCounters>() {

    override val strategiesToLoad = StrategyWithMetrikaCounters::class.java

    override val resourceType = StrategyResourceType.METRIKA_COUNTER_IDS

    override fun fillExportObject(strategy: StrategyWithMetrikaCounters, builder: Strategy.Builder) {
        builder.addAllMetrikaCounterIds(strategy.metrikaCounters ?: listOf())
    }
}
