package ru.yandex.direct.logicprocessor.processors.bsexport.strategy.handler

import ru.yandex.adv.direct.strategy.Strategy
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy
import ru.yandex.direct.logicprocessor.processors.bsexport.strategy.container.StrategyHandlerContainer
import ru.yandex.direct.logicprocessor.processors.bsexport.strategy.container.StrategyWithBuilder
import kotlin.reflect.safeCast

abstract class TypedStrategyResourceHandler<S : BaseStrategy> : IStrategyResourceHandler {
    abstract val strategiesToLoad: Class<S>

    final override fun handle(
        container: StrategyHandlerContainer,
        strategyById: Map<Long, StrategyWithBuilder<BaseStrategy>>
    ) {
        val relevantStrategyById = strategyById
            .filterValues { strategiesToLoad.isInstance(it.strategy) }
            .filter { hasClientId(container.clientById, it.value) }
            .mapValues { (_, strategy) ->
                StrategyWithBuilder(
                    strategiesToLoad.kotlin.safeCast(strategy.strategy)!!,
                    strategy.builder
                )
            }

        fillExportObjects(container, relevantStrategyById)
    }

    open fun fillExportObjects(container: StrategyHandlerContainer, strategyById: Map<Long, StrategyWithBuilder<S>>) {
        strategyById.values.forEach { fillExportObject(it.strategy, it.builder) }
    }

    open fun fillExportObject(strategy: S, builder: Strategy.Builder) {
    }
}
