package ru.yandex.direct.logicprocessor.processors.bsexport.strategy.utils

import ru.yandex.direct.core.entity.client.model.ClientNds
import java.math.BigDecimal
import java.time.LocalTime
import java.time.ZoneOffset

object ClientNdsConverter {
    private const val NDS_COEF = 1000000L;

    fun clientNdsToProto(clientNds: ClientNds) : ru.yandex.adv.direct.nds.Nds {
        val protoDateFrom = clientNds.dateFrom.toEpochSecond(LocalTime.MIN, ZoneOffset.UTC)
        val protoDateTo = clientNds.dateTo.toEpochSecond(LocalTime.MIN, ZoneOffset.UTC)
        //NDS в прото -- NDS в долях от единицы * 1000000
        val protoNds = clientNds.nds.asRatio().multiply(BigDecimal.valueOf(NDS_COEF)).toLong()

        val builder = ru.yandex.adv.direct.nds.Nds.newBuilder()
            .setDateFrom(protoDateFrom)
            .setDateTo(protoDateTo)
            .setNds(protoNds)

        return builder.build()
    }
}
