package ru.yandex.direct.logicprocessor.processors.bsexport.utils

import ru.yandex.direct.core.entity.campaign.model.MeaningfulGoal
import ru.yandex.direct.currency.CurrencyCode
import ru.yandex.direct.currency.Money

object MeaningfulGoalConverter {
    fun meaningfulGoalToProto(
        currencyCode: CurrencyCode,
        meaningfulGoal: MeaningfulGoal
    ): ru.yandex.adv.direct.campaign.MeaningfulGoal {
        val valueInMicros = Money.valueOf(meaningfulGoal.conversionValue, currencyCode).micros()
        val builder = ru.yandex.adv.direct.campaign.MeaningfulGoal.newBuilder()
            .setGoalId(meaningfulGoal.goalId)
            .setValue(valueInMicros)
        if (meaningfulGoal.isMetrikaSourceOfValue != null) {
            builder.isMetrikaSourceOfValue = meaningfulGoal.isMetrikaSourceOfValue
        }

        return builder.build()
    }
}
