package ru.yandex.direct.logicprocessor.processors.bsexport.utils

import ru.yandex.adv.direct.showcondition.RelevanceMatchData
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatchCategory

object YtRecordMappingUtils {
    private val RELEVANCE_MATCH_CATEGORY_MAPPING = mapOf(
        RelevanceMatchCategory.exact_mark to RelevanceMatchData.RelevanceMatchCategory.ExactMark,
        RelevanceMatchCategory.alternative_mark to RelevanceMatchData.RelevanceMatchCategory.AlternativeMark,
        RelevanceMatchCategory.competitor_mark to RelevanceMatchData.RelevanceMatchCategory.CompetitorMark,
        RelevanceMatchCategory.accessory_mark to RelevanceMatchData.RelevanceMatchCategory.AccessoryMark,
        RelevanceMatchCategory.broader_mark to RelevanceMatchData.RelevanceMatchCategory.BroaderMark
    )

    fun relevanceMatchCategoriesToYt(relevanceMatchCategories: Set<RelevanceMatchCategory>?): RelevanceMatchData {
        val categories = (relevanceMatchCategories ?: emptySet()).mapNotNull { RELEVANCE_MATCH_CATEGORY_MAPPING[it] }
        return RelevanceMatchData.newBuilder().addAllRelevanceMatchCategories(categories).build()
    }
}
