package ru.yandex.direct.logicprocessor.processors.campaignstatuscorrect;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.campaignstatuscorrect.CampaignStatusCorrectCheckConfig;
import ru.yandex.direct.ess.logicobjects.campaignstatuscorrect.CampaignStatusCorrectCheckObject;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.model.CheckTag;
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_0;

@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_0, CheckTag.DIRECT_PRODUCT_TEAM}
)
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10),
        needCheck = NonProductionEnvironment.class,
        tags = {DIRECT_PRIORITY_0})
@EssLogicProcessor(CampaignStatusCorrectCheckConfig.class)
public class CampaignStatusCorrectCheckProcessor extends BaseLogicProcessor<CampaignStatusCorrectCheckObject> {
    private static final Logger logger = LoggerFactory.getLogger(CampaignStatusCorrectCheckProcessor.class);
    private final CampaignStatusCorrectCheckService campaignStatusCorrectCheckService;

    @Autowired
    public CampaignStatusCorrectCheckProcessor(EssLogicProcessorContext essLogicProcessorContext,
                                               CampaignStatusCorrectCheckService campaignStatusCorrectCheckService) {
        super(essLogicProcessorContext);
        this.campaignStatusCorrectCheckService = campaignStatusCorrectCheckService;
    }

    @Override
    public void process(List<CampaignStatusCorrectCheckObject> objects) {
        int shard = getShard();
        //получаем cpm_price кампании из исходного списка
        List<Long> campaignIds = campaignStatusCorrectCheckService.getCpmPriceCampaigns(shard, objects);
        if (campaignIds.isEmpty()) {
            return;
        }
        logger.info(String.format("check status correct for %d campaigns, campaignIds: %s", campaignIds.size(), campaignIds));
        campaignStatusCorrectCheckService.verifyCampaignsStatusCorrect(shard, campaignIds);
    }
}
