package ru.yandex.direct.logicprocessor.processors.campstatusmoderate;

import java.util.Objects;

import org.jetbrains.annotations.Nullable;

import ru.yandex.direct.core.entity.campaign.model.CampaignStatusModerate;
import ru.yandex.direct.core.entity.campaign.model.CampaignStatusPostmoderate;

public class CampaignStatus {
    private final CampaignStatusModerate statusModerate;
    private final CampaignStatusPostmoderate statusPostModerate;
    private final boolean resendToBs;

    public CampaignStatus(CampaignStatusModerate campaignsStatusmoderate,
                          @Nullable CampaignStatusPostmoderate campaignStatusPostmoderate,
                          boolean resendToBs) {
        this.statusModerate = Objects.requireNonNull(campaignsStatusmoderate);
        this.statusPostModerate = campaignStatusPostmoderate;
        this.resendToBs = resendToBs;
    }

    public CampaignStatusModerate getStatusModerate() {
        return statusModerate;
    }

    public CampaignStatusPostmoderate getStatusPostModerate() {
        return statusPostModerate;
    }

    public boolean getResendToBs() {
        return resendToBs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampaignStatus that = (CampaignStatus) o;
        return statusModerate == that.statusModerate &&
                statusPostModerate == that.statusPostModerate &&
                resendToBs == that.resendToBs;
    }

    @Override
    public int hashCode() {
        return Objects.hash(statusModerate, statusPostModerate, resendToBs);
    }

    @Override
    public String toString() {
        return "CampaignStatus{" +
                "statusModerate=" + statusModerate +
                ", StatusPostModerate=" + statusPostModerate +
                ", statusBsSynced=" + resendToBs +
                '}';
    }
}
