package ru.yandex.direct.logicprocessor.processors.campstatusmoderate;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.campstatusmoderate.CampaignStatusModerateConfig;
import ru.yandex.direct.ess.logicobjects.moderation.campstatusmoderate.CampaignStatusEventsObject;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_2;

@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 5), needCheck = ProductionOnly.class, tags = {DIRECT_PRIORITY_2})
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class, tags = {DIRECT_PRIORITY_2})
@EssLogicProcessor(CampaignStatusModerateConfig.class)
public class CampaignStatusEventsProcessor extends BaseLogicProcessor<CampaignStatusEventsObject> {

    private final CampaignStatusCalcService campaignStatusCalcService;

    @Autowired
    public CampaignStatusEventsProcessor(EssLogicProcessorContext essLogicProcessorContext,
                                         CampaignStatusCalcService campaignStatusCalcService) {
        super(essLogicProcessorContext);
        this.campaignStatusCalcService = campaignStatusCalcService;
    }

    @Override
    public void process(List<CampaignStatusEventsObject> logicObjects) {
        campaignStatusCalcService.process(getShard(), logicObjects);
    }

}
