package ru.yandex.direct.logicprocessor.processors.campstatusmoderate;

import java.util.List;

import org.jetbrains.annotations.Nullable;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.campaign.model.CampaignStatusModerate;
import ru.yandex.direct.core.entity.campaign.model.CampaignStatusPostmoderate;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusmoderate;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;
import static ru.yandex.direct.dbschema.ppc.enums.CampOptionsStatuspostmoderate.Accepted;
import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;

@Repository
public class CampaignStatusModerateRepositoryImpl implements CampaignStatusModerateRepository {
    private final DslContextProvider dslContextProvider;

    @Autowired
    public CampaignStatusModerateRepositoryImpl(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    @Override
    public void setStatusModerate(int shard, List<Long> cids,
                                  CampaignStatusModerate statusModerate,
                                  @Nullable CampaignStatusPostmoderate statusPostModerate,
                                  boolean resendToBs) {

        if (statusModerate == null) {
            throw new IllegalArgumentException();
        }

        var updateStep = dslContextProvider.ppc(shard)
                .update(CAMPAIGNS.join(CAMP_OPTIONS).on(CAMPAIGNS.CID.eq(CAMP_OPTIONS.CID)))
                .set(CAMPAIGNS.STATUS_MODERATE, CampaignStatusModerate.toSource(statusModerate));

        if (statusPostModerate != null) {
            updateStep = updateStep.set(CAMP_OPTIONS.STATUS_POST_MODERATE,
                    DSL.iif(CAMP_OPTIONS.STATUS_POST_MODERATE.eq(Accepted), Accepted,
                            CampaignStatusPostmoderate.toSource(statusPostModerate)));
        }

        if (resendToBs) {
            updateStep = updateStep.set(CAMPAIGNS.STATUS_BS_SYNCED, CampaignsStatusbssynced.No);
        }

        updateStep.where(CAMPAIGNS.CID.in(cids)
                .and(CAMPAIGNS.STATUS_MODERATE.notIn(CampaignsStatusmoderate.New, CampaignsStatusmoderate.Ready)))
                .execute();
    }
}
