package ru.yandex.direct.logicprocessor.processors.campstatusmoderate.handlers;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.logicprocessor.processors.campstatusmoderate.CampaignStatus;
import ru.yandex.direct.logicprocessor.processors.campstatusmoderate.CampaignStatusEventsProcessor;
import ru.yandex.direct.logicprocessor.processors.campstatusmoderate.CampaignStatusModerateRepository;

@Component
public class CampaignsUpdater implements CampaignStatusHandler {
    private static final Logger logger = LoggerFactory.getLogger(CampaignStatusEventsProcessor.class);
    private final CampaignStatusModerateRepository campaignStatusModerateRepository;

    @Autowired
    public CampaignsUpdater(CampaignStatusModerateRepository campaignStatusModerateRepository) {
        this.campaignStatusModerateRepository = campaignStatusModerateRepository;
    }

    @Override
    public void process(int shard, Map<CampaignStatus, List<Long>> statusesToCids) {
        for (var state : statusesToCids.keySet()) {
            logger.info("Setting statuses statusModerate={}, statusPostModerate={}, bsSynced={},  cids={}",
                    state.getStatusModerate(), state.getStatusPostModerate(), state.getResendToBs(),
                    statusesToCids.get(state));

            if (state.getStatusModerate() == null) {
                logger.info("Skipping cids {}, because new statusModerate is null", statusesToCids.get(state));
                continue;
            }

            campaignStatusModerateRepository.setStatusModerate(shard, statusesToCids.get(state),
                    state.getStatusModerate(),
                    state.getStatusPostModerate(), state.getResendToBs());
        }
    }
}
