package ru.yandex.direct.logicprocessor.processors.conversioncenter

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.ess.config.conversioncenter.ConversionCenterEventConfig
import ru.yandex.direct.ess.logicobjects.conversioncenter.ConversionCenterEventObject
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.CheckTag
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessor
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext

@JugglerCheck(
    ttl = JugglerCheck.Duration(minutes = 20),
    needCheck = ProductionOnly::class,
    tags = [CheckTag.DIRECT_PRIORITY_2],
    notifications = [OnChangeNotification(
        method = [NotificationMethod.TELEGRAM],
        recipient = [NotificationRecipient.CHAT_CONVERSION_CENTER_BACK],
        status = [JugglerStatus.OK, JugglerStatus.CRIT],)],
)
@EssLogicProcessor(ConversionCenterEventConfig::class)
class ConversionCenterEventProcessor(
    essLogicProcessorContext: EssLogicProcessorContext,
    private val service: ConversionCenterEventService,
) : BaseLogicProcessor<ConversionCenterEventObject>(essLogicProcessorContext) {
    override fun process(logicObjects: MutableList<ConversionCenterEventObject>) {
        service.processCampaignStrategyChange(shard, logicObjects)
    }
}
