package ru.yandex.direct.logicprocessor.processors.conversioncenter

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository
import ru.yandex.direct.core.entity.campaign.repository.filter.CampaignFilterFactory
import ru.yandex.direct.core.entity.conversionsource.service.ConversionCenterMetrikaGoalsService
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.ess.logicobjects.conversioncenter.ConversionCenterEventObject
import ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory

@Service
class ConversionCenterEventService(
    private val campaignTypedRepository: CampaignTypedRepository,
    private val dslContextProvider: DslContextProvider,
    private val conversionCenterMetrikaGoalsService: ConversionCenterMetrikaGoalsService,
) {
    fun processCampaignStrategyChange(shard: Int, objects: List<ConversionCenterEventObject>) {
        val objectsByClientId = objects.groupBy { it.clientId }
        objectsByClientId.forEach { (id, objects) ->
            val clientId = ClientId.fromLong(id)
            val campaignIds = objects.map { it.campaignId }

            val dslContext = dslContextProvider.ppc(shard)
            val campaigns = campaignTypedRepository.getTypedCampaigns(dslContext,
                ConditionFilterFactory.multipleConditionFilter(
                    CampaignFilterFactory.campaignClientIdFilter(clientId),
                    CampaignFilterFactory.campaignIdsFilter(campaignIds),
                    CampaignFilterFactory.campaignTypesExceptFilter(setOf(CampaignType.MCB))
                )
            )
            conversionCenterMetrikaGoalsService.addCampaignGoalsToConversionCenter(clientId, campaigns, false)
        }
    }
}
