package ru.yandex.direct.logicprocessor.processors.feeds.statusupdate;

import java.util.List;
import java.util.Objects;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.xiva.XivaPushesQueueService;
import ru.yandex.direct.core.entity.xiva.model.XivaPushesQueueItem;
import ru.yandex.direct.core.entity.xiva.model.XivaPushesQueuePushType;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.feeds.statusupdate.FeedStatusUpdateConfig;
import ru.yandex.direct.ess.logicobjects.feeds.statusupdate.FeedStatusUpdateObject;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;

@JugglerCheck(
        needCheck = ProductionOnly.class,
        ttl = @JugglerCheck.Duration(minutes = 10),
        notifications = @OnChangeNotification(
                method = NotificationMethod.TELEGRAM,
                recipient = NotificationRecipient.LOGIN_BUHTER,
                status = {JugglerStatus.OK, JugglerStatus.CRIT}
        )
)
@EssLogicProcessor(FeedStatusUpdateConfig.class)
public class FeedStatusUpdateProcessor extends BaseLogicProcessor<FeedStatusUpdateObject>  {
    private final XivaPushesQueueService xivaPushesQueueService;
    private final FeatureService featureService;

    @Autowired
    public FeedStatusUpdateProcessor(EssLogicProcessorContext essLogicProcessorContext,
                                        XivaPushesQueueService xivaPushesQueueService, FeatureService featureService) {
        super(essLogicProcessorContext);
        this.xivaPushesQueueService = xivaPushesQueueService;
        this.featureService = featureService;
    }

    @Override
    public void process(List<FeedStatusUpdateObject> logicObjects) {
        xivaPushesQueueService.addPushesToQueue(
                createPushesByLogicObjects(logicObjects)
        );
    }

    protected List<XivaPushesQueueItem> createPushesByLogicObjects(List<FeedStatusUpdateObject> logicObjects) {
        return StreamEx.of(logicObjects).map(object -> {
            ClientId clientId  = ClientId.fromLong(object.getClientId());
            if (featureService.isEnabledForClientId(clientId, FeatureName.SEND_XIVA_PUSHES) &&
                    featureService.isEnabledForClientId(clientId, FeatureName.SEND_PUSH_FEED_STATUS_UPDATE)) {
                return new XivaPushesQueueItem()
                        .withClientId(object.getClientId())
                        .withPushType(XivaPushesQueuePushType.FEED_STATUS_CHANGED);
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }
}
