package ru.yandex.direct.logicprocessor.processors.mediascopeintegration;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.model.BannerMeasurer;
import ru.yandex.direct.core.entity.banner.model.BannerMeasurerSystem;
import ru.yandex.direct.core.entity.banner.repository.BannerRelationsRepository;
import ru.yandex.direct.core.entity.banner.type.measurers.BannerMeasurersRepository;
import ru.yandex.direct.ess.logicobjects.mediascopeintegration.MediascopePositionChangeObject;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Collectors.toSet;

@Service
@ParametersAreNonnullByDefault
public class BannerCollectorService {
    private final BannerRelationsRepository bannerRelationsRepository;
    private final BannerMeasurersRepository bannerMeasurersRepository;

    public BannerCollectorService(
            BannerRelationsRepository bannerRelationsRepository,
            BannerMeasurersRepository bannerMeasurersRepository
    ) {
        this.bannerRelationsRepository = bannerRelationsRepository;
        this.bannerMeasurersRepository = bannerMeasurersRepository;
    }

    public List<Long> getBannerIdsWithIntegration(int shard, List<MediascopePositionChangeObject> logicObjects) {
        List<Long> campaignIds = logicObjects.stream()
                .filter(object -> object.getCampaignId() != null)
                .map(MediascopePositionChangeObject::getCampaignId)
                .distinct()
                .collect(toList());
        List<Long> bannerIdsByCampaignIds = bannerRelationsRepository.getBannerIdsByCampaignIds(shard, campaignIds);

        List<Long> bannerIds = logicObjects.stream()
                .filter(object -> object.getBannerId() != null)
                .map(MediascopePositionChangeObject::getBannerId)
                .collect(toList());

        Set<Long> allBannerIds = Stream.concat(bannerIds.stream(), bannerIdsByCampaignIds.stream()).collect(toSet());
        Map<Long, List<BannerMeasurer>> measurersByBannerIds =
                bannerMeasurersRepository.getMeasurersByBannerIds(shard, allBannerIds);

        return EntryStream.of(measurersByBannerIds)
                .filterValues(measurers -> measurers.stream()
                        .anyMatch(measurer ->
                                BannerMeasurerSystem.MEDIASCOPE.equals(measurer.getBannerMeasurerSystem())
                                        && measurer.getHasIntegration()))
                .keys()
                .toList();
    }
}
