package ru.yandex.direct.logicprocessor.processors.metrika.bannerupdate;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.metrika.container.BannerWithTitleAndBody;

public class MetrikaBannerUpdateResult {

    @JsonProperty("bid")
    private long bid;

    @JsonProperty("bsBannerId")
    private long bsBannerId;

    @JsonProperty("title")
    private String title;

    @JsonProperty("body")
    private String body;

    MetrikaBannerUpdateResult(long bid, long bsBannerId, String title, String body) {
        this.bid = bid;
        this.bsBannerId = bsBannerId;
        this.title = title;
        this.body = body;
    }


    static MetrikaBannerUpdateResult fromCoreModel(BannerWithTitleAndBody bannerWithTitleAndBody) {
        return new MetrikaBannerUpdateResult(bannerWithTitleAndBody.getBid(), bannerWithTitleAndBody.getBannerId(),
                bannerWithTitleAndBody.getTitle(), bannerWithTitleAndBody.getBody());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MetrikaBannerUpdateResult that = (MetrikaBannerUpdateResult) o;
        return bid == that.bid &&
                bsBannerId == that.bsBannerId &&
                Objects.equals(title, that.title) &&
                Objects.equals(body, that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(bid, bsBannerId, title, body);
    }

    @Override
    public String toString() {
        return "MetrikaBannerUpdateResult{" +
                "bid=" + bid +
                ", bsBannerId=" + bsBannerId +
                ", title='" + title + '\'' +
                ", body='" + body + '\'' +
                '}';
    }
}
