package ru.yandex.direct.logicprocessor.processors.metrika.bannerupdate;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository;
import ru.yandex.direct.core.entity.metrika.container.BannerWithTitleAndBody;
import ru.yandex.direct.core.entity.metrika.repository.MetrikaBannerRepository;
import ru.yandex.direct.ess.common.utils.TablesEnum;
import ru.yandex.direct.ess.logicobjects.metrika.bannerupdate.MetrikaBannerUpdateObject;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Collectors.toSet;

@Service
public class MetrikaBannerUpdateService {

    private MetrikaBannerRepository metrikaBannerRepository;
    private BannerImageRepository bannerImageRepository;

    @Autowired
    public MetrikaBannerUpdateService(
            MetrikaBannerRepository metrikaBannerRepository,
            BannerImageRepository bannerImageRepository) {
        this.metrikaBannerRepository = metrikaBannerRepository;
        this.bannerImageRepository = bannerImageRepository;
    }

    List<MetrikaBannerUpdateResult> getMetrikaBannerUpdateResultList(
            int shard,
            List<MetrikaBannerUpdateObject> metrikaBannerUpdateObjects) {
        Set<Long> bannerImagesIds = metrikaBannerUpdateObjects.stream()
                .filter(object -> object.getTable().equals(TablesEnum.BANNER_IMAGES))
                .map(MetrikaBannerUpdateObject::getPrimaryKey)
                .collect(toSet());

        List<BannerWithTitleAndBody> imageBannersWithTitleAndBody =
                metrikaBannerRepository.getBannerWithTitleAndBodyFromImageIds(shard, bannerImagesIds);

        Set<Long> bids = metrikaBannerUpdateObjects.stream()
                .filter(object -> object.getTable().equals(TablesEnum.BANNERS))
                .map(MetrikaBannerUpdateObject::getPrimaryKey)
                .collect(toSet());

        Map<Long, Long> imageBsBannerIdsToBids = bannerImageRepository.getBannerIdsFromBids(shard, bids);

        Map<Long, BannerWithTitleAndBody> bannersWithTitleAndBody =
                metrikaBannerRepository.getBannerWithTitleAndBodyFromBids(shard, bids);

        List<BannerWithTitleAndBody> imageBsBannerIdsToBidsEnriched = imageBsBannerIdsToBids.entrySet().stream()
                .filter(e -> bannersWithTitleAndBody.containsKey(e.getValue()))
                .map(e -> {
                    BannerWithTitleAndBody parentBannerWithTitleAndBody = bannersWithTitleAndBody.get(e.getValue());
                    String title = parentBannerWithTitleAndBody.getTitle();
                    String body = parentBannerWithTitleAndBody.getBody();
                    return new BannerWithTitleAndBody(e.getValue(), e.getKey(), title, body);
                })
                .collect(toList());


        return Stream.of(imageBannersWithTitleAndBody, bannersWithTitleAndBody.values(), imageBsBannerIdsToBidsEnriched)
                .flatMap(Collection::stream)
                .distinct()
                .map(MetrikaBannerUpdateResult::fromCoreModel)
                .collect(toList());

    }
}
