package ru.yandex.direct.logicprocessor.processors.metrika.bannerupdate.logbroker;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlogbroker.logbroker_utils.writer.AbstractLogbrokerWriterImpl;
import ru.yandex.direct.binlogbroker.logbroker_utils.writer.LogbrokerWriterRetryConfig;
import ru.yandex.direct.logicprocessor.processors.metrika.bannerupdate.MetrikaBannerUpdateResult;
import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.kikimr.persqueue.producer.AsyncProducer;


@ParametersAreNonnullByDefault
public class MetrikaBannerUpdateLogbrokerWriter extends AbstractLogbrokerWriterImpl<MetrikaBannerUpdateResult> {

    public MetrikaBannerUpdateLogbrokerWriter(Supplier<CompletableFuture<AsyncProducer>> logbrokerProducerSupplier,
                                              Duration logbrokerTimeout, int retryCount) {
        super(logbrokerProducerSupplier, logbrokerTimeout, new LogbrokerWriterRetryConfig(retryCount));
    }

    @Override
    protected LogbrokerWriteRequest makeRequest(MetrikaBannerUpdateResult metrikaBannerUpdateResult) {
        return new LogbrokerWriteRequest(JsonUtils.toJsonBytes(metrikaBannerUpdateResult));
    }
}
