package ru.yandex.direct.logicprocessor.processors.moderation;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.container.ModerationLogEntry;
import ru.yandex.direct.core.entity.moderation.model.adgroup.AdGroupModerationMetaImpl;
import ru.yandex.direct.core.entity.moderation.model.adgroup.AdGroupModerationRequest;

@Component
public class AdGroupModerationRequestLogEntryCreator
        implements ModerationRequestLogEntryCreator<AdGroupModerationRequest> {

    @Override
    public <E extends AdGroupModerationRequest> ModerationLogEntry<E> createLogEntry(E moderationRequest) {
        AdGroupModerationMetaImpl meta = moderationRequest.getMeta();

        long campaignId = meta.getCampaignId();
        long adGroupId = meta.getAdGroupId();
        long bannerId = 0L;

        return new ModerationLogEntry<>(campaignId, adGroupId, bannerId,
                ModerationLogEntry.Action.REQUEST, true, moderationRequest);
    }
}
