package ru.yandex.direct.logicprocessor.processors.moderation;

import java.util.function.Function;

import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.ModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.ModerationRequest;
import ru.yandex.direct.core.entity.moderation.model.ModerationableWithBid;
import ru.yandex.direct.core.entity.moderation.service.sending.ModerationSendingService;
import ru.yandex.direct.ess.logicobjects.moderation.BaseModerationObject;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationRequestsWriter;
import ru.yandex.direct.logicprocessor.processors.moderation.writers.ModerationWriterMonitoring;
import ru.yandex.monlib.metrics.labels.Labels;

public abstract class BannerAssetSimpleModerationEventsProcessor<
        T extends BaseModerationObject,
        M extends ModerationableWithBid,
        D extends ModerationRequest<? extends ModerationMeta>> extends SimpleModerationEventsProcessor<T, M, D> {
    protected BannerAssetSimpleModerationEventsProcessor(EssLogicProcessorContext essLogicProcessorContext,
                                                         ModerationSendingService<Long, D, M> sender,
                                                         ModerationRequestsWriter<D> moderationWriter,
                                                         ModerationWriterMonitoring moderationWriterMonitoring,
                                                         ModerationOperationModeProvider moderationOperationModeProvider) {
        this(essLogicProcessorContext, sender, moderationWriter, moderationWriterMonitoring,
                moderationOperationModeProvider, ModerationableWithBid::getBid);
    }

    protected BannerAssetSimpleModerationEventsProcessor(EssLogicProcessorContext essLogicProcessorContext,
                                                         ModerationSendingService<Long, D, M> sender,
                                                         ModerationRequestsWriter<D> moderationWriter,
                                                         ModerationWriterMonitoring moderationWriterMonitoring,
                                                         ModerationOperationModeProvider moderationOperationModeProvider,
                                                         Function<M, Long> keyExtractor) {
        super(essLogicProcessorContext, keyExtractor,
                sender, moderationWriter, moderationWriterMonitoring, moderationOperationModeProvider);
    }

    protected Labels getTypeSpecificLabelsForMonitoring() {
        return Labels.empty();
    }
}
