package ru.yandex.direct.logicprocessor.processors.moderation;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.log.container.ModerationLogEntry;
import ru.yandex.direct.core.entity.moderation.model.BaseBannerModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.BaseBannerModerationRequest;

@Component
public class BannerModerationRequestLogEntryCreator
        implements ModerationRequestLogEntryCreator<BaseBannerModerationRequest<?, ?>> {

    @Override
    public <E extends BaseBannerModerationRequest<?, ?>> ModerationLogEntry<E> createLogEntry(E moderationRequest) {
        BaseBannerModerationMeta meta = moderationRequest.getMeta();

        long campaignId = meta.getCampaignId();
        long adGroupId = meta.getAdGroupId();
        long bannerId = meta.getBannerId();

        return new ModerationLogEntry<>(campaignId, adGroupId, bannerId,
                ModerationLogEntry.Action.REQUEST, true, moderationRequest);
    }
}
